//
//  TTTGameViewController.h
//  Tic-Tac-Toe-Storyboard
//
//  Created by Rajiv Ramnath on 9/2/13.
//  Copyright (c) 2013 Rajiv Ramnath. All rights reserved.
//

#import <UIKit/UIKit.h>
// #import <MessageUI/MFMailComposeViewController.h>
#import <MessageUI/MessageUI.h>
#import <AddressBookUI/AddressBookUI.h>
#import "TTTCheckpointable.h"
@class TTTGame;
@class TTTGameView;
@class TTTBoard;

#define SCOREPLAYERONEKEY "ScorePlayerOne"
#define SCOREPLAYERTWOKEY "ScorePlayerTwo"
#define TTTGAMESESSIONSAVEDFILEPATH "Documents/SavedGames.data"
#define TTTDELAY 5

@interface TTTGameSessionViewController : UIViewController <MFMailComposeViewControllerDelegate,
                                                            MFMessageComposeViewControllerDelegate,
                                                            ABPeoplePickerNavigationControllerDelegate,
                                                            TTTCheckpointable> {
    @private int scorePlayerOne;
    @private int scorePlayerTwo;
	@private TTTGame *activeGame;
	@private TTTGameView *gameView;
   	@private NSString *firstPlayerName;
	@private NSString *secondPlayerName;
    
}
    @property (nonatomic, retain) IBOutlet TTTBoard *boardView;
    @property (nonatomic, retain) IBOutlet UITextField *scoreTextField;
    @property (nonatomic, retain) IBOutlet UITextField *turnTextField;
    @property (nonatomic, retain)  IBOutlet UISwitch *changeOpponentSwitch;

    @property (nonatomic) BOOL playComputer;

    - (void) boardTouchedAt :(float) x :(float) y;
    - (IBAction) phoneAFriend:(id)sender;
    - (IBAction) sendScoresBySMS:(id)sender;
    - (IBAction) sendScoresByEmailWithContact:(id)sender;
    - (IBAction) changeOpponent:(id)sender;
    - (IBAction) saveGame:(id)sender;
    - (IBAction) restoreGame:(id)sender;
    - (IBAction) exit:(id)sender;
    - (void) checkpoint;

@end
